<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/8/2017
 * Time: 2:13 PM
 */

namespace App\System\Publisher\Database\Models;

use App\System\AppBaseModel;
use App\System\IsbnApplication\Database\Models\IsbnApplication;
use Carbon\Carbon;

class Publisher extends AppBaseModel  {

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->with = ['prefixes' => function ($query) {
            $query -> orderBy ('effective_date', 'desc');
        }];
    }

    public function prefixes () {
        return $this->hasMany(PublisherPrefix::class);
    }

    public function isbnApplications() {
        return $this->hasMany(IsbnApplication::class);
    }

    public function getActivePrefix () {
        if(!$this->relationLoaded('prefixes')) {
            $this->load(['prefixes' => function ($query) {
                $query -> orderBy ('effective_date', 'desc');
            }]);
        }
        $now = new Carbon();
        $modelBeforeToday = $this->prefixes->first(function ($prefix) use ($now) {
            return $now->isSameDay($prefix->effective_date) || $prefix->effective_date->isPast();
        });
        return $modelBeforeToday;
    }

    public function toArray()
    {
        $return = parent::toArray();
        $return['active_prefix'] = $this->getActivePrefix();
        return $return;
    }

}
