<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/12/2017
 * Time: 10:26 AM
 */

namespace App\System\Payment\Vipps;


use Vipps\Vipps;

class Client extends \Http\Adapter\Guzzle6\Client
{
    /**
     * @var array
     */
    protected $config = [];
    /**
     * @var \Vipps\Vipps
     */
    protected $vippsClient = null;
    /**
     * Payment factory
     * @var \Vipps\Resources\Payments
     */
    protected $payment;

    /**
     * Client constructor.
     * @param \GuzzleHttp\ClientInterface $client
     */
    public function __construct($client = null)
    {
        $this->loadConfig();

        if($client==null){
            $client = $this->httpClient();
        }
        parent::__construct($client);
        $this->createVippsClient();
    }

    /**
     * Create Vipps Client
     */
    protected function createVippsClient(){
        $this->vippsClient = new Vipps($this);
        $this->vippsClient->setMerchantID($this->config[$this->config['environment']]['merchant_id'])
            ->setMerchantSerialNumber($this->config[$this->config['environment']]['merchant_serial_number'])
            ->setMerchantSerialNumber($this->config[$this->config['environment']]['merchant_token']);
        $this->payment = $this->vippsClient->payments();
    }

    /**
     * Load the configuration file
     */
    protected function loadConfig(){
        $this->config = require __DIR__."/config/config.php";
    }

    /**
     * Get the certificate
     */
    protected function getCert(){
        //TODO: Have to determine what is the type of the content of the cert and then rework on it. For now lets send a file string only
        return file_get_contents($this->config[$this->config['environment']]['certificate']['cert']);
    }

    /**
     * Get the http Client for requesting it
     */
    protected function httpClient(){
        return new \GuzzleHttp\Client(['cert'=>$this->getCert()]);
    }

    /**
     * @param $uniqueOrderId
     * @param $phoneNumber
     * @param $amountInOre
     * @param $description
     * @param $callback
     * @return mixed
     */
    public function createPayment($uniqueOrderId,$phoneNumber,$amountInOre,$description,$callback){
        //TODO: Work on Callback|work on Exception | work on issues
        $this->payment->setOrderID($uniqueOrderId);
        return $this->payment->create($phoneNumber,$amountInOre,$description,$callback);
    }

    /**
     * @param $paymentId
     * @return mixed
     */
    public function getPaymentDetails($paymentId){
        $this->payment->setOrderID($paymentId);
        return $this->payment->getDetails();
    }

    /**
     * @param $paymentId
     * @return mixed
     */
    public function getPaymentStatus($paymentId){

        $this->payment->setOrderID($paymentId);
        return $this->payment->getStatus();
    }


}