<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/12/2017
 * Time: 3:19 PM
 */

namespace App\System\Payment;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;

abstract class TransactionRow implements Jsonable, Arrayable
{

    protected $id;
    protected $description;
    protected $amount;
    protected $date;
    protected $status;
    protected $time;
    protected $data;
    protected $extraColumns = [];
    protected $rowMapper;

    /**
     * TransactionRowMap constructor.
     * @param TransactionRowMapInterface $rowMapper
     */
    public function __construct(TransactionRowMapInterface $rowMapper)
    {
        $this->rowMapper = $rowMapper;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return TransactionRow
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     * @return TransactionRow
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param mixed $amount
     * @return TransactionRow
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param mixed $date
     * @return TransactionRow
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return TransactionRow
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getTime()
    {
        return $this->time;
    }

    /**
     * @param mixed $time
     * @return TransactionRow
     */
    public function setTime($time)
    {
        $this->time = $time;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     * @return TransactionRow
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @param $data
     */
    public function setExtraDataColumn($data){
        $this->extraColumns = $data;
    }

    /**
     * @return mixed
     */
    protected function getValueFromData($key){
        if(isset($this->data[$key])){
            return $this->data[$key];
        }else{
            return null;
        }
    }

    protected function setPropertiesFromData(){

        $this->setDescription($this->getValueFromData($this->rowMapper->getKeyForDescription()));
        $this->setAmount($this->getValueFromData($this->rowMapper->getKeyForAmount()));
        $this->setData($this->getValueFromData($this->rowMapper->getKeyForDate()));
        $this->setStatus($this->getValueFromData($this->rowMapper->getKeyForStatus()));
        $this->setTime($this->getValueFromData($this->rowMapper->getKeyForTime()));
        $this->setId($this->getValueFromData($this->rowMapper->getKeyForId()));


    }

    public function toArray(){
        $data  = [
            'id'=>$this->id,
            'description'=>$this->description,
            'amount'=>$this->amount,
            'date'=>$this->date,
            'status'=>$this->status,
            'time'=>$this->time,
            'data'=>$this->data,
        ];

        foreach($this->extraColumns as $key=>$name){
            $data[$key] = $this->getValueFromData($key);
        }

        return $data;

    }

    public function toJson($option = 0){
        return (object)$this->toArray();
    }

}