<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/11/2017
 * Time: 5:22 PM
 */

namespace App\System\Payment\Tests;


use App\System\Payment\GatewayException;
use App\System\Payment\NicoServicePaymentFactory;
use Illuminate\Contracts\Console\Kernel;
use Illuminate\Foundation\Testing\TestCase;

class UnitTest extends TestCase
{
    protected $app = null;
    /**
     * Creates the application.
     *
     * Needs to be implemented by subclasses.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernelInterface
     */
    public function createApplication()
    {
        $app = require __DIR__."/../../../../bootstrap/app.php";

        $app->make(Kernel::class)->bootstrap();
        $this->app = $app;
        return $app;
    }

    /**
     * Test the gateway creation
     */
    public function testGatewayCreationWithDefault(){

        $gateway = NicoServicePaymentFactory::gateway();
        $this->assertNotNull($gateway);

    }

    public function testExceptionForInvalidGateways(){
        $this->expectException(GatewayException::class);
        NicoServicePaymentFactory::gateway('invalidgateway');
    }


}