<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/11/2017
 * Time: 1:04 PM
 */

namespace App\System\Payment;

/**
 * The Payment Factory. It is responsible for creating payment gateways and make it available for use.
 * Class NicoServicePaymentFactory
 * @package App\System\Payment
 */
class NicoServicePaymentFactory
{

    /**
     * @var $gateway
     * @type GatewayInterface
     */
    protected static $gateway;

    /**
     * Get the config array from file
     * @return array
     */
    private static function getConfigArray():array {
        //get system gateway-config
        $config = $systemConfig = include (__DIR__)."/gateway-config.php";

        //get developers gateway-config
        try{
            $devConfig = include(config_path('gateway-config.php'));
            if(null!=$devConfig){
                $config = array_merge($systemConfig,$devConfig);
            }
        }catch (\ErrorException $errorException){

        }
        // override system gateway-config with developers' gateway-config

        return $config;
    }

    /**
     * Create instance of the given type class or throw an exception
     * @param string $type
     * @return GatewayInterface
     */
    private static function createInstanceOrFail(string $type):GatewayInterface{
        $config = array_dot(static::getConfigArray());
        if(!array_key_exists($type,array_dot($config))){
            throw new GatewayProviderNotFoundException("Provider for $type not found. Please make sure the provider is listed in the configuration file.");
        }
        $instance = new $config[$type];
        if(!($instance instanceof GatewayInterface)){
            throw new GatewayInstanceException($config[$type]);
        }
        return $instance;
    }

    /**
     * Get the payment gateway. Creates and returns gateway
     * @param string $which Note that the arguments must match the
     * @expectException
     * @return GatewayInterface
     */
    public static function gateway(string $which=null):GatewayInterface{
        //get the config array
        $config = static::getConfigArray();
        //get the gateway
        $gateway = "gateways.".array_get($config,'default');
        //Override with the argument
        if($which!=null){
            $gateway = $which;
        }

        static::$gateway = static::createInstanceOrFail($gateway);
        return static::$gateway;
    }
}