<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/11/2017
 * Time: 4:00 PM
 */

namespace App\System\Payment;


class InvalidGatewayInstanceException extends GatewayException
{
    /**
     * @var string
     */
    protected $code = "NICO-GA1001";
    /**
     * @var string
     */
    protected $messageTemplate = "The {{instanceName}} must be an instance of " . 'App\System\Payment\GatewayInterface';

    /**
     * Get message from template
     * @param $instanceName
     * @return string
     */
    private function generateMessageFromTemplate($instanceName):string{
        return str_replace("{{instanceName}}",$instanceName,$this->messageTemplate);
    }

    /**
     * GatewayInstanceException constructor.
     * @param string $instanceName
     * @param string $message
     * @param int $code
     * @param \Exception $previous
     */
    public function __construct($instanceName,$message = "", $code = 0, \Exception $previous = null)
    {
        if(!$message){
            $message = $this->generateMessageFromTemplate($instanceName);
        }
        parent::__construct($message, $code, $previous);
    }
}