<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/11/2017
 * Time: 1:07 PM
 */

namespace App\System\Payment;

/**
 * Interface GatewayInterface
 * @package App\System\Payment
 */
interface GatewayInterface
{
    /**
     * Set data for request.
     * @param $data
     * @return void
     */
    public function setData($data);

    /**
     * Create payment
     * @return ResponseInterface
     */
    public function createPayment():ResponseInterface;

    /**
     * Get payment detail
     * @param $id
     * @return ResponseInterface
     */
    public function getPaymentDetailById($id):ResponseInterface;

    /**
     * Get Payment status
     * @param $id
     * @return ResponseInterface
     */
    public function getPaymentStatus($id):ResponseInterface;

}