<?php


namespace App\System\IsbnApplication\Database\Models;


use App\System\AppBaseModel;
use App\System\Publisher\Database\Models\Publisher;
use App\System\Publisher\Database\Models\PublisherPrefix;
use Milon\Barcode\DNS1D;
use Picqer\Barcode\BarcodeGeneratorPNG;
use Picqer\Barcode\Exceptions\BarcodeException;

class IssuedIsbn extends AppBaseModel
{
    protected $with = ['publisherPrefix'];

    protected $defaultSortColumn = "isbn_number";
/*
    public function getIsbnNumberAttribute () {
        if (!$this->publisherPrefix) {
           return $this->attributes['isbn_number'];
        }
        $prefix = $this->publisherPrefix->prefix;
        $attribute = $this->attributes['isbn_number'];
        $combinedLength = strlen($prefix.$attribute);
        $missingNumber = 5 - $combinedLength;
        if ($missingNumber > 0) {
            for($i=0;$i<$missingNumber;$i++) {
                $attribute = "0".$attribute;
            }
        }

        return $attribute;
    }
 */
    public function isbnApplication () {
        return $this->belongsTo(IsbnApplication::class);
    }

    public function publisherPrefix () {
        return $this->belongsTo(PublisherPrefix::class);
    }

    public function publisher () {
        return $this->belongsTo(Publisher::class);
    }

    public function getBarcodePngBase64 () {
        $code = $this->getBarcodePng();
        if($code) {
            return base64_encode($code);
        }
        return $code;
    }

    public function getBarcodePng () {
        $code = null;
        if(isset($this->attributes['readonly']) && $this->attributes['readonly'] == 1 && isset($this->attributes['full_isbn_number'])) {

            try {
                $code = DNS1D::getBarcodePNG($this->attributes['full_isbn_number'],'EAN13',2,100,[0,0,0],true);
                $code = base64_decode($code);
            } catch (BarcodeException $e) {
            } catch (\Exception $exception) {

            }
        }
        return $code;
    }

    public function toArray()
    {
        $return =  parent::toArray();
        $code = $this->getBarcodePngBase64();
        if($code) {
            $return['base64_barcode'] = $code;
        }
        return $return;
    }

}
