<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/8/2017
 * Time: 2:13 PM
 */

namespace App\System\IsbnApplication\Database\Models;

use App\System\AppBaseModel;
use App\System\Publisher\Database\Models\Publisher;
use App\System\IsbnApplication\Database\Models\ApplicationIllustration;

class IsbnApplication extends AppBaseModel  {

    protected $with = ['issuedIsbn'];

    public function publisher () {
        return $this->belongsTo(Publisher::class, 'publisher_id');
    }

    public function issuedIsbn () {
        return $this->hasOne(IssuedIsbn::class);
    }

    public function authors () {
        return $this->hasMany(Author::class);
    }

    public function illustrations() {
        return $this->hasMany(ApplicationIllustration::class);
    }
}
