<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 1/14/19
 * Time: 2:18 PM
 */

namespace App\System\Foundation\SystemQuery;


use Illuminate\Support\Collection;
use ReflectionClass;

class SystemQueryScope
{

    /**
     * @var Collection $queries
     */
    protected static $queries = [];

    public static function getAllQueries () {
        return static::$queries;
    }

    /**
     * @param $name
     * @return Query
     */
    public static function getQueryInstance($name)
    {
        foreach (static::$queries as $queryName => $instance) {
            if ($name === $queryName) {
                return $instance;
            }
        }

        static::$queries[$name] = new Query();

        return static::$queries[$name];

    }

    /**
     * @return array
     * @throws \ReflectionException
     */
    public static function getOptions()
    {
        $oClass = new ReflectionClass(__CLASS__);
        return $oClass->getConstants();
    }


}
