<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 2/1/19
 * Time: 3:01 PM
 */

namespace App\System\Foundation\Repositories;


use App\System\Site\Database\Models\Reseller;
use NicoSystem\Foundation\Database\BaseModel;
use NicoSystem\Repositories\BaseRepository;

abstract class AppBaseRepository extends BaseRepository
{

    function __construct(BaseModel $model)
    {
        parent::__construct($model);
    }

    /**
     * @param array $inputs
     * @return mixed
     */
    public function create(array $inputs)
    {
        if (in_array('site_id', $this->model->getFillable())) {
            if (!array_get($inputs, 'site_id')) {
                $inputs['site_id'] = Reseller::getDefaultReseller()->id;
            }
        }
        return parent::create($inputs);
    }



}