<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 10/17/2017
 * Time: 4:51 PM
 */

namespace App\System;

use Illuminate\Http\Response;

/**
 * Add constants that are used throughout the application. Try to have values for constants that are unique.
 * Class AppConstants
 * @package App\System
 */
class AppConstants
{
    protected $reseller;

    protected $isImpersonateUser = false;

    static $instance;

    /**
     * The general constant value for most of the success response
     * @type string
     */
    const SUCCESS_OK = 'ok';

    const ERR_CODE_ZERO = 0;

    const ERR_CODE_404 = 404;

    /** Note that this constant group is made as per \Illuminate\Contracts\Auth\PasswordBroker constant. We've only replaced dot with an underscore */
    const SUCCESS_PASSWORD_RESET_SUCCESS = "passwords_reset";

    const SUCCESS_PASSWORD_RESET_LINK_SENT = "passwords_sent";

    const ERR_PASSWORD_INVALID_USER = "passwords_user";

    const ERR_PASSWORD_INVALID_PASSWORD = "passwords_password";

    const ERR_PASSWORDS_TOKEN = "passwords_token";

    const ERR_PASSWORD_NOT_UPDATED = "password_not_updated";


    /**
     * Used typically whenever user try to submitForm with invalid username/password combination
     * @type string
     */
    const ERR_INVALID_CREDENTIAL = 'invalid_credentials';
    /**
     * Used typically whenever required value in the request is empty
     * @type string
     */
    const ERR_REQUIRED_FIELDS_EMPTY = 'required_fields_empty';

    const ERR_EMAIL_DOESNT_EXIST_IN_DATABASE = 'email_doesnt_exist_in_system';

    const ERR_MAIL_SERVER_AUTH_OR_CONF = "mail_server_auth_or_conf_error";

    const ERR_FORM_VALIDATION = "form_validation_error";

    const ERR_OLD_PASSWORD_MISMATCH = "old_password_mismatch";

    const ERR_INTERNAL_SERVER_ERROR = "internal_server_error";

    const ERR_UNAUTHORIZED = "unauthorized";

    const ERR_FORBIDDEN = "forbidden";

    const ERR_NOT_FOUND = "not_found";

    const ERR_BAD_REQUEST = "err_bad_request";

    const ERR_PRECONDITION_FAILED = "precondition_failed";

    const ERR_CONFLICT = "conflict";

    const ERR_EXPECTATION_FAILED = "expectation_failed";

    const ERR_USER_NOT_LOGGED_IN_OR_TOKEN_ABSENT = "user_not_logged_in_or_token_absent";

    const ERR_INVALID_OAUTH_CLIENT = 'invalid_client';

    const ERR_METHOD_NOT_ALLOWED = "method_not_allowed";

    const ERR_AUTH_TOKEN_ABSENT = 'auth_token_absent';

    const ERR_INVALID_AUTH_TOKEN = 'invalid_auth_token';

    const ERR_TOKEN_EXPIRED = 'auth_token_expired';

    const ERR_TOO_MANY_LOGIN_ATTEMPT = 'too_many_bad_login_attempt';

    const ERR_RESOURCE_IN_USE = 'err_resource_in_use';

    const ERR_RESOURCE_NOT_FOUND = 'err_resource_not_found';

    const ERR_MODEL_NOT_EDITABLE = "err_resource_not_editable";
    const ERR_DUPLICATE_PERMISSION_GROUP = "err_duplicate_permission_group";

    const ERR_PERMISSION_NOT_EXIST = "err_permission_not_exist";

    const ERR_PERMISSION_GROUP_NOT_EXIST = "err_permission_group_not_exist";

    const ERR_NOT_SUFFICIENT_PERMISSION = "err_not_sufficient_permission";

    const ERR_FAILED_TO_DELETE_DEFAULT_PERMISSION = "err_failed_to_delete_default_permission";

    const ERR_FAILED_TO_EDIT_DEFAULT_PERMISSION = "err_failed_to_edit_default_permission";

    const ERR_MODEL_SUSPENDED = "err_resource_suspended";

    const ERR_MODEL_UNPUBLISHED = "err_resource_unpublished";

    const ERR_SITE_TOKEN_MISMATCH = "site_token_mismatch";

    const ERR_INVALID_DOMAIN_PASSWORD = "invalid_site_credentials";

    const ERR_PROTECTED_SITE = "err_site_protected";

    const ERR_INVALID_DATA_SUBMISSION = "err_invalid_data_submission";

    const ERR_DUPLICATE_RESOURCE = "err_duplicate_resource";

    const ERR_ADMIN_DELETION = "err_admin_deletion";

    const ERR_CANNOT_IMPERSONATE = "err_cannot_impersonate";

    const ERR_CANNOT_IMPERSONATE_DEFAULT = "err_cannot_impersonate_default";

    const ERR_CANNOT_IMPERSONATE_ITSELF = "err_cannot_impersonate_itself";

    const MSG_JOB_ON_PROCESS = "msg_job_on_process";

    const MSG_JOB_FINISHED = "msg_job_finished";

    const MSG_JOB_FAILED = "msg_job_failed";

    const ERR_EMAIL_CONFIRMATION = "err_email_confirmation";

    const  ERR_MULTIPLE_ISBN_ATTEMPT = 'err_multiple_isbn_creation_attempt';

    const ERR_ACTIVE_PREFIX_UNAVAILABLE = 'err_active_publisher_prefix_not_available';

    const ERR_DUPLICATE_ISBN_NUMBER_ISSUE = 'err_duplicate_isbn_number_issue';

    /**
     * @return AppConstants
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new self();
        }
        return static::$instance;
    }

    /**
     * @param $reseller
     * @return AppConstants
     */

    public function setReseller($reseller)
    {
        $this->reseller = $reseller;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getReseller()
    {
        return $this->reseller;
    }

    /**
     * @return bool
     */
    public function isImpersonateUser(): bool
    {
        return $this->isImpersonateUser;
    }

    /**
     * @param bool $isImpersonateUser
     */
    public function setIsImpersonateUser(bool $isImpersonateUser): void
    {
        $this->isImpersonateUser = $isImpersonateUser;
    }

    /**
     * @param $code
     * @return int|string
     */
    public static function getAppMsgCodeFromStatusCode($code)
    {
        switch ($code) {
            case 400:
                return static::ERR_BAD_REQUEST;
            case 401:
                return static::ERR_UNAUTHORIZED;
            case 403:
                return static::ERR_FORBIDDEN;
            case 404:
                return static::ERR_NOT_FOUND;
            case Response::HTTP_METHOD_NOT_ALLOWED:
                return static::ERR_METHOD_NOT_ALLOWED;
            case Response::HTTP_EXPECTATION_FAILED:
                return static::ERR_EXPECTATION_FAILED;
            case Response::HTTP_PRECONDITION_FAILED:
                return static::ERR_PRECONDITION_FAILED;
            case Response::HTTP_INTERNAL_SERVER_ERROR:

                return static::ERR_INTERNAL_SERVER_ERROR;
            default:
                return static::ERR_CODE_ZERO;
        }
    }

}
