<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 10/22/2017
 * Time: 5:24 PM
 */

namespace App\System;

use App\System\Scopes\GlobalQueryScope;
use NicoSystem\Data\Status;
use NicoSystem\Foundation\Database\EditorLogs;
use App\System\User\Database\Models\User;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use NicoSystem\Foundation\Database\BaseModel;
use App\System\Foundation\SystemQuery\SystemQueryScope;

abstract class AppBaseModel extends BaseModel
{
    use SoftDeletes, EditorLogs;

    /**
     * @var string $globalQueryName global query name
     */
    protected $globalQueryName;

    /**
     * Hidden attributes
     * @var array
     */
    protected $hidden = ['deleted_at','updated_by','created_by','deleted_by','pivot'];
    /**
     * @const STATUS_ACTIVE
     */
    const STATUS_ACTIVE = 1;
    /**
     * @const STATUS_INACTIVE
     */
    const STATUS_INACTIVE = 0;

    protected $perPage = 100;

    /**
     * AppBaseModel constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope(new GlobalQueryScope(static::getGlobalQuery()));
    }

    /**
     * Tell what model should the model use while updating/creating/deleting.
     * Example return Auth::user()
     * @return mixed
     */
    public  function editorProvider(){
        return Auth::user();
    }
    /**
     * What model to use if editor log is enabled. example User::class
     * @return string
     */
    public function getEditorModelClassName():string {
        return User::class;
    }

    /**
     * Active scope definition
     * @param $builder
     */
    public function scopeActive($builder){
        $builder->where('status',self::STATUS_ACTIVE);
    }

    /**
     * Check whether the model is editable or not
     * @return boolean
     */
    public function isEditable () {
        return $this->getAttribute('status') !== Status::STATUS_SUSPENDED;
    }

    /**
     * Get GlobalQuery
     */
    public static function getGlobalQuery () {
        $static = new static();
        $queryName = $static -> globalQueryName;
        if(!$queryName) {
            $queryName = $static->getTable();
        }
        return SystemQueryScope::getQueryInstance($queryName);
    }

}
