<?php

namespace App\Providers;


use App\Listeners\FileEventSubscriber;
use App\Listeners\IsbnApplicationEventSubscriber;
use App\Listeners\JobEventSubscriber;
use App\Listeners\PublisherEventSubscriber;
use App\Listeners\UserEventSubscriber;
use App\Listeners\VideoEventSubscriber;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [

    ];

    protected $subscribe = [
        JobEventSubscriber::class,
        FileEventSubscriber::class,
        UserEventSubscriber::class,
        PublisherEventSubscriber::class,
        IsbnApplicationEventSubscriber::class,
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
