<?php
namespace App\Modules\UserManagement;

use App\Modules\UserManagement\Providers\EventServiceProvider;
use \Illuminate\Support\ServiceProvider as BaseServiceProvider;

/**
 * Class ServiceProvider
 * @package App\Modules\UserManagements
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * @type bool
     */
    protected $defer = true;
    /**
     * Register your binding
     */
    public function register(){

        $this->app->bind('App\Modules\UserManagement\Interfaces\UserManagementInterface','App\Modules\UserManagement\Repositories\UserManagementRepository');
        $this->app->register(EventServiceProvider::class);

    }

    public function boot()
    {

    }
}