<?php
/**
 * Created by PhpStorm.
 * User: Rocco
 * Date: 10/31/2018
 * Time: 12:07 PM
 */

namespace App\Modules\UserManagement\Listeners;

use App\Events\User\UserUpdated;
use App\Modules\UserManagement\Mails\UserInvitation;
use App\System\User\Database\Models\User;
use Illuminate\Support\Facades\Mail;


class UserManagementEventSubscriber
{

    public function onCreated(UserUpdated $event)
    {
        if($event->new !==  true) {
            return;
        }
        $user = $event->user;
        $password = $event->password;
        $this->sendEmail($user,$password);
    }
    

    /**
     * @param User $user
     * @param $password
     */
    private function sendEmail(User $user, $password)
    {
        Mail::to($user->email)->queue(new UserInvitation($user, $password));
    }


    public function subscribe($events)
    {
        $events->listen(UserUpdated::class, UserManagementEventSubscriber::class . '@onCreated');
    }



}