<?php
namespace App\Modules\UAC;

use App\Modules\UAC\Providers\EventServiceProvider;
use \Illuminate\Support\ServiceProvider as BaseServiceProvider;

/**
 * Class ServiceProvider
 * @package App\Modules\UACS
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * @type bool
     */
    protected $defer = true;
    /**
     * Register your binding
     */
    public function register(){

        $this->app->bind('App\Modules\UAC\Interfaces\PermissionInterface','App\Modules\UAC\Repositories\PermissionRepository');
        $this->app->bind('App\Modules\UAC\Interfaces\PermissionGroupInterface','App\Modules\UAC\Repositories\PermissionGroupRepository');
        $this->app->bind('App\Modules\UAC\Interfaces\UserPermissionGroupInterface','App\Modules\UAC\Repositories\UserPermissionGroupRepository');

        $this->app->register(EventServiceProvider::class);
    }

}