<?php
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth:api']], function () {


    //Route For assign un-assign user to permission-group

    Route::put('/permission-groups/{permissionGroup}/users/{user}','UserPermissionGroupController@store')
        -> middleware ('nicoAuth:null,app.users.assign_permission_group');
    Route::delete('/permission-groups/{permissionGroup}/users/{user}','UserPermissionGroupController@destroy')
        -> middleware ('nicoAuth:null,app.users.un_assign_permission_group');;

    Route::group(['middleware'=>['nicoAuth']], function (){
        Route::get('/permissions','PermissionsController@index');

        Route::get('/permission-groups','PermissionGroupsController@index');
        Route::get('/permission-groups/{permissionGroup}','PermissionGroupsController@show');
    });
});
