<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/4/19
 * Time: 2:48 PM
 */

namespace App\Modules\UAC\Requests;


use App\System\UAC\Foundation\DefaultGroup;
use NicoAuth\NicoAuth;
use NicoSystem\Requests\NicoRequest;

class PermissionGroupCreateRequest extends NicoRequest
{
    public function rules()
    {
        return [
            'permission' => 'required|array|exists:' . NicoAuth::TABLE_PERMISSION . ',key',
            'group_name' => 'required|max:30|not_in:'.implode(',',DefaultGroup::options()),
            'description'=>'required|string'
        ];
    }

}