<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/8/19
 * Time: 10:46 AM
 */

namespace App\Modules\UAC\Repositories;


use App\Modules\UAC\Database\Models\User;
use App\Modules\UAC\Interfaces\UserPermissionGroupInterface;
use App\System\AppConstants;
use App\System\Foundation\Repositories\AppBaseRepository;
use Illuminate\Database\Eloquent\Builder;
use NicoSystem\Exceptions\NicoBadRequestException;


class UserPermissionGroupRepository extends AppBaseRepository implements UserPermissionGroupInterface
{

    /**
     * UserPermissionGroupRepository constructor.
     * @param User $model
     *
     */
    public function __construct(User $model)
    {
        parent::__construct($model);
    }

    /**
     * @param Builder $builder
     * @return null
     */
    public function getFilter(Builder $builder)
    {
    }

    /**
     * @param $userId
     * @param $permissionGroupId
     * @param $namespace
     * @param null $namespaceId
     * @return mixed
     */
    public function assignUserToGroup($permissionGroupId, $userId, $namespace, $namespaceId = null)
    {
        $user = $this->getById($userId);
        $authManager = $user->loadAuthManager();
        $permissionGroup = $authManager->getPermissionGroup($permissionGroupId, $namespace, $namespaceId);
        if ($permissionGroup) {
            $user->assignGroup($permissionGroup);
            return $user;
        } else {
            throw new NicoBadRequestException("PermissionGroup Not Exist for given Namespace", AppConstants::ERR_PERMISSION_GROUP_NOT_EXIST);
        }


    }

    /**
     * @param $permissionGroupId
     * @param $userId
     * @param $namespace
     * @param null $namespaceId
     * @return mixed|\NicoSystem\Foundation\Database\BaseModel
     */
    public function removeUserFromGroup($permissionGroupId, $userId, $namespace, $namespaceId = null)
    {
        $user = $this->getById($userId);
        $authManager = $user->loadAuthManager();

        $group = $authManager->getPermissionGroup($permissionGroupId, $namespace, $namespaceId);
        $user->removeFromGroup($group);
    }

}