<?php

namespace App\Modules\UAC\Repositories;

use App\Modules\UAC\Interfaces\PermissionInterface;
use App\System\Foundation\Repositories\AppBaseRepository;
use Illuminate\Database\Eloquent\Builder;
use NicoAuth\AuthManager;

/**
 * Class PermissionRepository
 * @package App\Modules\UACS\Repositories
 */
class PermissionRepository implements PermissionInterface
{
    /**
     * @param array $params
     * @param bool $paginate
     * @param array $attributes
     * @return mixed
     */
    public function getList(array $params = [], $paginate = true, array $attributes = [])
    {
        return AuthManager::getAvailablePermissions(array_get($params,'namespace'));
    }
}