<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/4/19
 * Time: 3:13 PM
 */

namespace App\Modules\UAC\Repositories;


use App\Events\UAC\PermissionGroup\Deleted;
use App\Modules\UAC\Database\Models\Permission;
use App\Modules\UAC\Database\Models\PermissionGroup;
use App\Modules\UAC\Interfaces\PermissionGroupInterface;
use App\System\AppConstants;
use App\System\Foundation\Repositories\AppBaseRepository;
use App\System\UAC\Foundation\DefaultGroup;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use NicoAuth\AuthManager;
use NicoSystem\Exceptions\NicoBadRequestException;

class PermissionGroupRepository implements PermissionGroupInterface
{

    /**
     * @param array $inputs
     * @return mixed
     */
    public function create(array $inputs)
    {
        return;
    }

    /**
     * @param $id
     * @param array $attributes
     * @return mixed
     */
    public function update($id, array $attributes)
    {
       return;
    }

    /**
     * @param array $attributes
     * @param null $id
     * @return mixed
     */
    protected function save(array $attributes, $id = null)
    {
       return null;
    }


    /**
     * @param $namespace
     * @return bool|mixed
     */
    public function checkNameSpace($namespace)
    {
        $options = ['app'] + config('nicoAuth.namespaces', []);;

        return in_array($namespace, $options);

    }


    /**
     * @param $namespace
     * @param $id
     * @return bool
     */
    public function checkNameSpaceId($namespace, $id)
    {
        if ($namespace == 'app') {
            return true;
        };
        $className = config('nicoAuth.providers.' . $namespace);
        if ($className) {
            $model = new $className;
            $row = $model->find($id);
            return $row instanceof $className;
        }
        return false;
    }

    /**
     * @param array $params
     * @param bool $paginate
     * @param array $attributes
     * @return \Illuminate\Support\Collection|mixed
     */
    public function getList(array $params = [], $paginate = true, array $attributes = [])
    {
        //TODO: Have to implement it from Auth module

        $list = AuthManager::getAllPermissionGroups();

        return $list->filter(function ($group) {
            return !($group->key == DefaultGroup::GROUP_MEMBER || $group->key == DefaultGroup::DEFAULTGROUP);
        })->flatten();
    }

    /**
     * @param $id
     * @param array $attributes
     * @return mixed|\NicoSystem\Foundation\Database\BaseModel
     */
    public function getById($id, array $attributes = [])
    {
        $group = AuthManager::getPermissionGroup($id);
        if (!$group) {
            throw new ModelNotFoundException();
        }
        return $group;
    }

    /**
     * @param $id
     * @param array $attributes
     * @return mixed|void
     */
    public function destroy($id, array $attributes = [])
    {
        return;
    }
}
