<?php
/**
 * Created by PhpStorm.
 * User: Rocco
 * Date: 11/2/2018
 * Time: 3:29 PM
 */

namespace App\Modules\UAC\Mails;


use App\System\User\Database\Models\ActiveUser;
use Illuminate\Mail\Mailable;

class ResellerAdminCreated extends Mailable
{
    /**
     * @var
     */
    public $user;
    public $domain;

    /**
     * ResellerAdminCreated constructor.
     * @param ActiveUser $user
     * @param $domain
     */
    public function __construct(ActiveUser$user,$domain)
    {
        $this->user=$user;
        $this->domain=$domain;
    }

    public function build()
    {

        return $this->subject(trans('reseller_admin_notifier.subject'))
            ->view(nico_view('emails.reseller-admin-notifier',[],[],true))->with([
            'receiver'=>ucfirst($this->user->first_name),
            'loginUrl'=>route('frontend.login'),
            'url'=>$this->domain,route('root'),
            'title' => trans('reseller_admin_notifier.title')
        ]);
    }
}