<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 2/13/19
 * Time: 9:01 AM
 */

namespace App\Modules\UAC\Listeners;


use App\Events\User\BeforeUserResponse;
use App\Events\User\UserDeleted;
use Illuminate\Auth\Events\Registered;
use NicoAuth\AuthManager;

class UserEventsSubscriber
{
    public function onUserDeleted(UserDeleted $event) {
        // remove all user from the reseller
        $authManager = new AuthManager($event->user);
        $authManager->removeFromNamespace ($event->namespace, $event->namespaceSubject->id);
    }

    /**
     * Create the event listener.
     *
     * @param BeforeUserResponse $event
     * @return \App\System\User\Database\Models\Abstracts\AbstractUser|null
     */
    public function beforeRetrieved(BeforeUserResponse $event)
    {
        $user=$event->user;
        return $user->load('permissionGroups');
    }

    public function onUserRegistered(Registered $registered) {
        $group = AuthManager::getPermissionGroup('registered_users');
        $authManager = new AuthManager($registered->user);
        $authManager->addToPermissionGroup($group);
    }
    /**
     * @param mixed $event
     */
    public function subscribe ($event) {
        $event -> listen (UserDeleted::class, UserEventsSubscriber::class . "@onUserDeleted");
        $event -> listen(BeforeUserResponse::class, UserEventsSubscriber::class . '@beforeRetrieved');
        $event -> listen(Registered::class, UserEventsSubscriber::class . '@onUserRegistered');
    }
}
