<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/8/19
 * Time: 12:21 PM
 */

namespace App\Modules\UAC\Controllers;


use App\Events\UAC\PermissionGroup\AssignUser;
use App\Events\UAC\PermissionGroup\UnassignUser;
use App\Modules\UAC\Interfaces\ResellerInterface;
use App\Modules\UAC\Interfaces\UserPermissionGroupInterface;
use App\System\AppConstants;
use App\System\User\Database\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use NicoAuth\AuthManager;
use NicoSystem\Controllers\BaseController;
use NicoSystem\Exceptions\NicoBadRequestException;

class UserPermissionGroupController extends BaseController
{
    /**
     * UserPermissionGroupController constructor.
     * @param UserPermissionGroupInterface $repository
     */
    public function __construct(UserPermissionGroupInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param Request $request
     * @param $permissionGroupId
     * @param $userId
     * @param bool $remove
     * @return mixed
     */
    protected function addOrRemoveUserToPermissionGroup(Request $request, $permissionGroupId, $userId, $remove = false)
    {
        $user = User::select('id')->find($userId);

        $authUser = Auth::user();

        if ($authUser->id == $user->id) {
            throw new NicoBadRequestException("User can't edit his own permission.",AppConstants::ERR_NOT_SUFFICIENT_PERMISSION);
        }

        if (!$user) {
            throw new NicoBadRequestException("User with id $userId not found");
        }

        $group = AuthManager::getPermissionGroup($permissionGroupId);

        if (!$group) {
            throw new NicoBadRequestException("Invalid permission group id");
        }

        $user->loadPermissionAndPermissionGroups();

        if ($remove) {
            $user->unAssignGroup($group);
            event(new UnassignUser($group,$user));
        } else {
            $user->assignGroup($group);
            event(new AssignUser($group,$user));
        }


        return $this->responseOk("");

    }


    /**
     * @param Request $request
     * @param $permissionGroupId
     * @param $userId
     * @return mixed
     */
    public function store(Request $request, $permissionGroupId, $userId)
    {
        return $this->addOrRemoveUserToPermissionGroup($request, $permissionGroupId, $userId, false);
    }


    /**
     * @param Request $request
     * @param $permissionGroupId
     * @param $userId
     * @return mixed
     */
    public function destroy(Request $request, $permissionGroupId, $userId)
    {
        return $this->addOrRemoveUserToPermissionGroup($request, $permissionGroupId, $userId, true);
    }
}
