<?php

namespace App\Modules\UAC\Controllers;

use App\Modules\UAC\Interfaces\PermissionInterface;
use NicoSystem\Requests\NicoRequest;

/**
 * Class PermissionsController
 * @package App\Modules\UACS\Controllers
 */
class PermissionsController extends PermissionBaseController {
    /**
     * PermissionsController constructor.
     * @param PermissionInterface $repository
     */
    public function __construct(PermissionInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param NicoRequest $request
     * @return \Illuminate\Http\Response
     */
    public function index(NicoRequest $request){
        $this->processRequestForDomainNamespace($request);
        return $this->responseOk($this->repository->getList($request->all()));
    }


}