<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/4/19
 * Time: 2:40 PM
 */

namespace App\Modules\UAC\Controllers;


use App\Events\UAC\PermissionGroup\Created;
use App\Events\UAC\PermissionGroup\Updated;
use App\Modules\UAC\Interfaces\PermissionGroupInterface;
use App\Modules\UAC\Requests\PermissionGroupCreateRequest;
use App\Modules\UAC\Requests\PermissionGroupUpdateRequest;
use NicoSystem\Requests\NicoRequest;

/**
 * Class PermissionGroupsController
 * @package App\Modules\UAC\Controllers
 */
class PermissionGroupsController extends PermissionBaseController
{
    /**
     * PermissionGroupsController constructor.
     * @param PermissionGroupInterface $repository
     */
    public function __construct(PermissionGroupInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param NicoRequest $request
     * @param $namespace
     * @param null $namespaceId
     * @return mixed
     */
    public function index(NicoRequest $request)
    {
        return $this->responseOk($this->repository->getList($request->all()));
    }

    /**
     * @param PermissionGroupCreateRequest $request
     * @param $namespace
     * @param $namespaceId
     * @return mixed
     */
    public function store(PermissionGroupCreateRequest $request)
    {

        $permissionGroup = $this->repository->create($request->all());
        event(new Created($permissionGroup));
        return $this->responseOk($permissionGroup);
    }

    /**
     * @param PermissionGroupUpdateRequest $request
     * @param $permissionGroupId
     * @param $namespace
     * @param null $namespaceId
     * @return mixed
     */
    public function update(PermissionGroupUpdateRequest $request, $id)
    {
        $permissionGroup= $this->repository->update($id, $request->all());
        event(new Updated($permissionGroup));
        return $this->responseOk($permissionGroup);
    }

    /**
     * @param NicoRequest $request
     * @param $namespace
     * @param $permissionGroupId
     * @param null $namespaceId
     * @return mixed
     */
    public function show(NicoRequest $request, $permissionGroupId)
    {
        $result = $this->repository->getById($permissionGroupId, $request->all());
        return $this->responseOk($result);
    }

    /**
     * @param NicoRequest $request
     * @param $namespace
     * @param $permissionGroupId
     * @param null $namespaceId
     * @return mixed
     */
    public function delete(NicoRequest $request, $permissionGroupId)
    {
        return $this->responseOk($this->repository->destroy($permissionGroupId, $request->all()));
    }
}
