<?php
use Illuminate\Support\Facades\Route;


Route::group(['middleware'=>'auth:api'],function(){
    Route::put('publishers/{publisher}/administrator/{user}','PublishersController@assignAdministrator') ->middleware('nicoAuth:publishers,app.publishers.assign_owner');
    Route::delete('publishers/{publisher}/administrator','PublishersController@removeAdministrator') ->middleware('nicoAuth:publishers,app.publishers.assign_owner');
    Route::resource('publishers','PublishersController') -> middleware('nicoAuth:publishers');
    Route::get('publishers/{publisher}/prefixes/active', 'PublisherPrefixesController@getActivePrefix')->middleware('nicoAuth:publisher_prefixes');

    Route::resource('publishers.prefixes', 'PublisherPrefixesController')
        ->middleware('nicoAuth:publisher_prefixes')
    ->only('store','index','destroy','update');

    Route::post('publisher/request-publisher','PublishersController@requestPublisher');
    Route::get('publisher/request-publishers-list', 'PublishersController@getRequestPublisher');
    Route::get('publisher/request-publishers-list/{id}', 'PublishersController@getRequestPublisherById');
    Route::put('publisher/request-accept/{id}', 'PublishersController@acceptRequestPublisher');
    Route::post('publishers/request-publisher-owner/create-wonership', 'PublishersController@requestPublisherOwnership');
    Route::get('publisher/request-publisher-owner', 'PublishersController@getRequestPublisherOwner');
    Route::put('publisher/request-publisher-owner/request-accept/{id}', 'PublishersController@acceptRequestPublisherOwner');
    Route::get('publisher/ownership', 'PublishersController@getRequestPublisherOwnerList');
    
});