<?php
namespace App\Modules\Publishers\Requests;

use NicoSystem\Requests\NicoRequest;

/**
 * Class PublisherCreateRequest
 * @package App\Modules\Publishers\Requests
 */
class RequestPublisherRequest extends NicoRequest
{
    public function rules(){
        return [
            'title' => 'required|max:191',
            'street' =>'required|max:191',
            'city' => 'required|max:191',
            'phone_number'=>'required|max:20|phone',
            'fax_number' => 'nullable|max:20|phone',
            'email' =>'required|email|max:100',
            'logo_url' =>'nullable',
        ];
    }

     /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'title.required' => 'A Publisher Name is required',

        ];
    }
}
