<?php
namespace App\Modules\Publishers\Requests;

use NicoSystem\Requests\NicoRequest;

/**
 * Class PublisherCreateRequest
 * @package App\Modules\Publishers\Requests
 */
class PublisherCreateRequest extends NicoRequest
{
    public function rules(){
        return [
            'title' => 'required|max:191',
            'street' =>'required|max:191',
            'city' => 'nullable|max:191',
            'phone_number'=>'nullable|max:20|phone',
            'fax_number' => 'nullable|max:20|phone',
            'email' =>'nullable|email|max:100|unique:publishers',
            'logo_url' =>'nullable',
        ];
    }
}
