<?php
namespace App\Modules\Publishers\Requests;

use Illuminate\Validation\Rule;
use NicoSystem\Requests\NicoRequest;

/**
 * Class PublisherCreateRequest
 * @package App\Modules\Publishers\Requests
 */
class PrefixCreateRequest extends PrefixRequest
{
    public function rules(){
        $rules =  [
            'prefix' => ['required','numeric','max:9999','digits_between_composite:0-2,30-49,500-799,8000-9999'],
            'effective_date' => 'required|date',
        ];
        $prefix = $this->request->get('prefix');
        $country_prefix = $this->request->get('country_prefix');
        $param = $this->route()->parameter('prefix');
        if(!in_array(intval($prefix),[0,1,2])) {
            $rl = 'unique:publisher_prefixes,prefix,NULL,id,country_prefix,'.$country_prefix;
            if($param) {
                $rl .= ',id,'.$param;
            }
            $rules['prefix'][] = $rl;
        } else {
            $rl = '';
            if($param) {
                $rl = 'unique:publisher_prefixes,id,'.$param;
            }
        }

        return $rules;
    }
}
