<?php

namespace App\Modules\Publishers\Repositories;

use App\Events\Publisher\PrefixDeleting;
use App\Modules\Publishers\Database\Models\PublisherPrefix;
use App\Modules\Publishers\Interfaces\PublisherPrefixInterface;
use App\System\Publisher\Database\Models\Publisher;
use Illuminate\Database\Eloquent\Builder;
use NicoSystem\Repositories\BaseRepository;

/**
 * Class PublisherRepository
 * @package App\Modules\Publishers\Repositories
 */
class PublisherPrefixRepository extends BaseRepository implements PublisherPrefixInterface
{
    protected $user;
    protected $publisher = null;
    /**
     * PublisherRepository constructor.
     * @param PublisherPrefix $model
     */
    public function __construct(PublisherPrefix $model, Publisher $publisher)
    {
        parent::__construct($model);
        $this->publisher = $publisher;
        $this->events['deleting'] = PrefixDeleting::class;
    }
    public function getFilter(Builder $builder) {
        return null;
    }

    public function getList(array $params = [], $paginate = false, array $attributes = [])
    {
        $this->getQuery()->where('publisher_id', array_get($params, 'publisher_id'));
        return parent::getList($params, $paginate, $attributes);
    }

    public function create(array $inputs)
    {
        $publisher = $this->publisher->newQuery()->findOrFail(array_get($inputs, 'publisher_id'));
        $model = $this->model->newInstance($inputs);
        $model->publisher_id = $publisher->id;
        $this->dispatchCreatingUpdatingEvent(true, $model);
        return $model->save ();
    }

    public function getActive ($publisherId) {
        $publisher = $this->publisher->newQuery()->findOrFail($publisherId);
        return $publisher->getActivePrefix();
    }

}
