<?php
namespace App\Modules\Publishers\Database\Models;

use App\System\Publisher\Database\Models\Publisher as BaseModel;
use App\System\User\Database\Models\User;

/**
 * Class Publisher
 * @package App\Modules\Publishers\Database\Models
 */
class Publisher extends BaseModel
{
    /**
     * @var array
     */
    protected $fillable = ['title','street','city','phone_number','fax_number','email','logo_url'];
    /**
     * @var array
     */
    protected $hidden = [];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public function administrator () {
        return $this->belongsTo(User::class, 'owner');
    }



}
