<?php

namespace App\Modules\Publishers\Controllers;

use App\Modules\Publishers\Interfaces\PublisherInterface;
use App\Modules\Publishers\Requests\PublisherCreateRequest;
use App\Modules\Publishers\Requests\PublisherDeleteRequest;
use App\Modules\Publishers\Requests\PublisherRequest;
use App\Modules\Publishers\Requests\PublisherUpdateRequest;
use App\Modules\Publishers\Requests\RequestPublisherRequest;
use NicoSystem\Requests\NicoRequest;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * Class PublishersController
 * @package App\Modules\Publishers\Controllers
 */
class PublishersController extends BaseController {
    /**
     * PublishersController constructor.
     * @param PublisherInterface $repository
     */
    public function __construct(PublisherInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        return $this->responseOk($this->repository->getList($request->all()));
    }

    /**
     * @param PublisherCreateRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(PublisherCreateRequest $request){
        return $this->responseOk($this->repository->create($request->all()));
    }

    /**
     * @param PublisherUpdateRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function update(PublisherUpdateRequest $request,$id){
        return $this->responseOk($this->repository->update($id,$request->all()));
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function destroy(Request $request,$id){
        return $this->responseOk($this->repository->destroy($id));
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function show (Request $request,$id){
        return $this->responseOk($this->repository->getById($id));

    }

    /**
     * @param Request $request
     * @param $id
     * @param $userId
     * @return mixed
     */
    public function assignAdministrator(Request $request, $id, $userId) {
        return $this->responseOk($this->repository->assignAdministrator ($id, $userId));
    }

    public function removeAdministrator(Request $request, $id) {
        return $this->responseOk($this->repository->removeAdministrator ($id));
    }

    public function requestPublisher(RequestPublisherRequest $request) {
       
        return $this->responseOk($this->repository->requestPublisher($request->all()));
    }

    public function getRequestPublisher(NicoRequest $request)
    {
        return $this->responseOk($this->repository->getPublisherRequestList($request->all()));
    }

    public function getRequestPublisherById($id)
    { 

        return $this->responseOk($this->repository->getRequestPublisherById($id));
    }

    public function acceptRequestPublisher(Request $request, $id)
    {
        return $this->responseOk($this->repository->acceptRequestPublisher($id));
    }

    public function requestPublisherOwnership(Request $request)
    {
        return $this->responseOk($this->repository->requestPublisherOwnership($request));
    }

    public function getRequestPublisherOwner()
    {
        return $this->responseOk($this->repository->getPublisherRequestOwner());
    }

    public function acceptRequestPublisherOwner($id)
    {
        return $this->responseOk($this->repository->acceptRequestPublisherOwner($id));
    }

    public function getRequestPublisherOwnerList(Request $request)
    {
        return $this->responseOk($this->repository->getRequestPublisherOwnerList($request->all()));
    }

}
