<?php

namespace App\Modules\Publishers\Controllers;

use App\Modules\Publishers\Interfaces\PublisherInterface;
use App\Modules\Publishers\Interfaces\PublisherPrefixInterface;
use App\Modules\Publishers\Requests\PrefixCreateRequest;
use App\Modules\Publishers\Requests\PrefixRequest;
use App\Modules\Publishers\Requests\PrefixUpdateRequest;
use App\Modules\Publishers\Requests\PublisherCreateRequest;
use App\Modules\Publishers\Requests\PublisherDeleteRequest;
use App\Modules\Publishers\Requests\PublisherRequest;
use App\Modules\Publishers\Requests\PublisherUpdateRequest;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * Class PublishersController
 * @package App\Modules\Publishers\Controllers
 */
class PublisherPrefixesController extends BaseController {
    /**
     * PublishersController constructor.
     * @param PublisherPrefixInterface $repository
     */
    public function __construct(PublisherPrefixInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param PrefixRequest $request
     * @return \Illuminate\Http\Response
     */
    public function index(PrefixRequest $request, $publisherId){
        $request->merge(['publisher_id' => $publisherId]);
        return $this->responseOk($this->repository->getList($request->all()));
    }

    /**
     * @param PrefixCreateRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(PrefixCreateRequest $request, $publisherId){
        $request->merge(['publisher_id' => $publisherId]);
        return $this->responseOk($this->repository->create($request->all()));
    }

    /**
     * @param PrefixUpdateRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function update(PrefixUpdateRequest $request, $publisherId ,$id){
        $request->merge(['publisher_id' => $publisherId]);
        return $this->responseOk($this->repository->update($id,$request->all()));
    }

    /**
     * @param PrefixRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function destroy(PrefixRequest $request, $publisherId ,$id){
        $request->merge(['publisher_id' => $publisherId]);
        return $this->responseOk($this->repository->destroy($id));
    }

    public function getActivePrefix (PrefixRequest $request, $publisherId) {
        return $this->responseOk($this->repository->getActive($publisherId));
    }


}
