<?php

namespace App\Modules\Opens\Repositories;

use App\Modules\Opens\Interfaces\OpenInterface;
use App\Modules\Opens\Database\Models\Open;
use App\System\Publisher\Database\Models\Publisher;
use NicoSystem\Repositories\BaseRepository;

/**
 * Class OpenRepository
 * @package App\Modules\Opens\Repositories
 */
class PublisherRepository
{
    protected $model;

    public function __construct(Publisher $model)
    {
        $this->model = $model;
    }

    public function getList (array $params = []) {
        
	$publisher = $this->model;

        $keyword = array_get($params,'keyword');

        if($keyword) {

            $publisher = $publisher->where('title','like',"%{$keyword}%");

        }

        return $publisher->paginate(50);
    }
}
