<?php

namespace App\Modules\Opens\Repositories;

use App\Modules\IsbnApplications\Database\Models\IssuedIsbn;
use App\System\IsbnApplication\Database\Models\IsbnApplication;
use App\System\Publisher\Database\Models\Publisher;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Query\JoinClause;

/**
 * Class OpenRepository
 * @package App\Modules\Opens\Repositories
 */
class IsbnRepository
{
    protected $model;

    protected $publisher;

    protected $application;

    public function __construct(IssuedIsbn $model, Publisher $publisher, IsbnApplication $application)
    {
        $this->model = $model;
        $this->publisher = $publisher;
        $this->application = $application;
    }

    protected function attachParamFilters (array $params, $query) {
        $keyword = array_get($params,'keyword');
        if($keyword) {
            $query->where (function ($q) use ($keyword){
                $q->orWhere('isbn_applications.title','like',"%{$keyword}%");
                $q->orWhere('subject','like',"%{$keyword}%");
		$q->orWhere('keywords','like',"%{$keyword}%");
		$q->orWhere('full_isbn_number','like',"%{$keyword}%");
           //     $q->orWhere('publishers.title','like',"%{$keyword}%");
            });

        }

        $orderBy = array_get($params,'order-by');
        $orderDir = array_get($params, 'order-dir');
        if($orderDir && !in_array($orderDir, ['asc','desc'])) {
            $orderDir = 'asc';
        }
        if($orderBy && !in_array($orderBy,['title','author'])) {
            $orderBy = 'title';
        }

        switch ($orderBy) {
            case 'title':
                $query->orderBy('title',$orderDir);
                break;
        }
        return $query;

    }

    public function getList (array $params = []) {
        // For Issued ISBN, we'll be returning ISBN that has isbns issued.
        $isbnTable = $this->model->getTable();
        $appTable = $this->application->getTable();
        $isbnQuery = $this->application -> newQuery();
        $isbnQuery -> leftJoin($isbnTable, function (JoinClause $join) use ($isbnTable, $appTable) {
            $join->on( "{$isbnTable}.isbn_application_id", '=', "{$appTable}.id")
                ->whereNull("{$isbnTable}.deleted_at");

        })
            ->select("{$appTable}.*")
            ->whereNotNull("{$isbnTable}.id")
            ->with(['publisher' => function ($query) {
                $query->without(['prefixes']);
                $query->select ('id','title','street','city');
            }, 'issuedIsbn' => function ($query){
                $query->without('publisherPrefix');
                $query->select('id','publisher_id','isbn_application_id','isbn_number','issued_date','readonly','full_isbn_number');
            },'authors']);

            $isbnQuery ->select(
           "{$appTable}.title"
           ,"{$appTable}.isbn_type"
           ,"{$appTable}.edition"
           ,"{$appTable}.subject"
           ,"{$appTable}.id"
           ,"{$appTable}.publisher_id"
           ,"{$appTable}.language"
           ,"{$appTable}.year"
           ,"{$appTable}.price"
           ,"{$appTable}.book_cover_url"

   );
	  // $isbnQuery->leftJoin('publishers', function (JoinClause $join) use ($appTable) {
          //     $join->on( "publishers.id", '=', "{$appTable}.publisher_id");
          // });
           $isbnQuery->where("{$appTable}.received_status", 1);
           $this->attachParamFilters($params, $isbnQuery);
           return $isbnQuery->paginate(100);
    }

    public function show ($id) {
        return $this->application->newQuery()
            ->with(['publisher','authors'])
            ->where('received_status', 1)
            ->findOrFail($id);
    }


}
