<?php

namespace App\Modules\Opens\Controllers;

use App\Modules\Opens\Interfaces\OpenInterface;
use App\Modules\Opens\Repositories\IsbnRepository;
use App\Modules\Opens\Repositories\PublisherRepository;
use App\Modules\Opens\Requests\OpenCreateRequest;
use App\Modules\Opens\Requests\OpenDeleteRequest;
use App\Modules\Opens\Requests\OpenRequest;
use App\Modules\Opens\Requests\OpenUpdateRequest;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * Class OpensController
 * @package App\Modules\Opens\Controllers
 */
class IssuedIsbnController extends BaseController {

    public function __construct(IsbnRepository $repository)
    {
        $this->repository = $repository;
    }

    public function index(Request $request){
        return $this->responseOk($this->repository->getList($request->all()));
    }

    public function show (Request $request, $id) {
        return $this->responseOk($this->repository->show($id));
    }


}
