<?php
namespace App\Modules\UserManagement\Requests;

use NicoSystem\Requests\NicoRequest;

/**
 * Class UserManagementCreateRequest
 * @package App\Modules\UserManagements\Requests
 */
class UserManagementCreateRequest extends NicoRequest
{
    public function rules()
    {
        return [
            'first_name'=>'required|string|max:20',
            'last_name'=>'required|string|max:20',
            'middle_name'=>'string|max:20',
            'email'=>'required|string|email|max:100',
            'username'=>'string|unique:users|max:100',
            'avatar'=>'mimetypes:image/png,image/jpeg'
        ];
    }
}