<?php

namespace App\Modules\Notices\Repositories;


use App\System\AppConstants;
use NicoSystem\Repositories\BaseRepository;
use App\System\Scopes\GlobalQueryScope;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use NicoSystem\Exceptions\NicoBadRequestException;
use App\Modules\Notices\Database\Models\Notice;
use Illuminate\Support\Facades\DB;


/**
 * Class NoticeRepository
 * @package App\Modules\Notices\Repositories
 */
class NoticeRepository extends BaseRepository
{
    public $model;
    /**
     * NoticesRepository constructor.
     * @param Notice $model
     */
    public function __construct(Notice $model)
    {
        parent::__construct($model);
        $this->model = $model;

    }

    public function getList(array $params = [], $paginate = true, array $attributes = [])
    {
        return DB::table('notices as r')
        ->select('r.id',
                'r.title',
                'r.body',
                'r.created_at',
                'r.created_by')
        ->where('r.deleted_at', null)
        ->orderBy('id','desc')
        ->paginate(10);
        
    }



    /**
     * @param array $inputs
     * @return mixed
     */
    public function create(array $inputs)
    {
         $user = parent::create($inputs);    
    }

    /**
     * @param $id
     * @param array $attributes
     * @return
     */
    public function getById($id, array $attributes = [])
    {
        return DB::table('notices')->where('id',$id)->first();
    }

    public function getFilter($builder)
    {
        
    }

    public function destroy($id, array $options = [])
    {
        return DB::table('notices')->delete($id);
    }

   


    public function update($id, array $options = [])
    {
        $notice = DB::table('notices')->where('id',$id)->first();
        // dd($options);
       if($notice){
            $options['created_by'] = Auth::user()->id;
            $options['updated_by'] = Auth::user()->id;
            // $options['created_by'] = 99;

            DB::table('notices')->where('id',$id)->update($options);
            // $notice->save();
        }else {
            throw new NicoException("No data found");
        }
    }


}
