<?php
/**
 * Created by PhpStorm.
 * User: Rocco
 * Date: 11/12/2018
 * Time: 12:35 PM
 */

namespace App\Modules\UserManagement\Mails;


use App\System\User\Database\Models\User;
use Illuminate\Mail\Mailable;


class UserInvitation extends Mailable
{

    /**
     * @var User
     */
    private $user;

    /**
     * @var
     */
    private $password;

    /**
     * UserInvitation constructor.
     * @param User $user
     * @param $domain
     */
    public function __construct(User $user, $password)
    {
        $this->user = $user;
        $this->password = $password;
    }

    /**
     * @return UserInvitation
     */
    public function build()
    {
        return $this->subject(trans('user_invitation.subject'))
            ->view(nico_view('emails.user-invitation',[],[],true))->with([
                'receiver' => $this->user->first_name,
                'username' => $this->user->email,
                'url' => url('/'),
                'loginUrl' => route('frontend.login'),
                'password' => $this->password,
                'title' => trans('user_invitation.title'),
            ]);
    }
}
