<?php

namespace App\Modules\Notices\Controllers;

use App\Modules\Notices\Repositories\NoticeRepository;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
use NicoSystem\Controllers\BaseController;
use NicoSystem\Data\Status;
use NicoSystem\Requests\NicoRequest;

/**
 * Class NoticeController
 * @package App\Modules\Notices\Controllers
 */
class NoticeController extends BaseController 
{
    /**
     * 
     * @param NoticeInterface $repository
     */
    public function __construct(NoticeRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param NicoRequest $request
     * @return \Illuminate\Http\Response
     */
    public function index(NicoRequest $request)
    {
        return $this->responseOk($this->repository->getList($request->all()));
    }

    /**
     * @param  $request
     * @return \Illuminate\Http\Response
     * @throws ValidationException
     */
    public function create(NicoRequest $request)
    {
        return $this->responseOk($this->repository->create($request->all()));
    }

    /**
     * @param NicoRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function show(NicoRequest $request, $id)
    {

        return $this->responseOk($this->repository->getById($id));
    }

    /**
     * @param $id
     * @return mixed
     */
    public function destroy($id)
    {
        $this->repository->destroy($id);
        return $this->responseOk('');
    }

    public function update(NicoRequest $request, $id)
    {
        $data = $request->all();
        $this->repository->update($id, $data);
        return $this->responseOk('');
    }





}
