<?php
use Illuminate\Support\Facades\Route;
Route::group(['middleware' => ['auth:api']], function() {

    Route::group (['middleware' => ['nicoAuth:isbn_applications']], function () {
        Route::post('isbn-applications/{id}/commit', 'IsbnApplicationsController@commitChangesPermanently');
        Route::post('isbn-applications/{id}/mark-as-received', 'IsbnApplicationsController@markAsReceived');
        Route::resource('isbn-applications','IsbnApplicationsController');
    });

    Route::get('isbn-applications/{app}/issued-isbns/new-isbn-identifier', 'ApplicationIssuedIsbnController@generateNextISBN');


    Route::post('isbn-applications/{app}/issued-isbns/{id}/commit', 'ApplicationIssuedIsbnController@commit')
        ->middleware('nicoAuth:isbn,app.isbn.commit');

    Route::group(['middleware' => ['nicoAuth:isbn']], function () {
        Route::get('isbn-applications/{app}/issued-isbns','ApplicationIssuedIsbnController@index');
        Route::post('isbn-applications/{app}/issued-isbns','ApplicationIssuedIsbnController@store');
        Route::put('isbn-applications/{app}/issued-isbns/{id}','ApplicationIssuedIsbnController@update');
        Route::get('isbn-applications/{app}/issued-isbns/{id}','ApplicationIssuedIsbnController@show');
        Route::delete('isbn-applications/{app}/issued-isbns/{id}','ApplicationIssuedIsbnController@destroy');
    });

    Route::post('issued-isbns/{id}/commit', 'IssuedIsbnController@commit')->middleware('nicoAuth:isbn,app.isbn.commit');


    Route::group(['middleware' => ['nicoAuth:isbn']], function () {
        Route::get('issued-isbns', 'IssuedIsbnController@index');
        Route::get('issued-isbns/{id}', 'IssuedIsbnController@show');
        Route::delete('issued-isbns/{id}', 'IssuedIsbnController@destroy');
    });


});
