<?php

namespace App\Modules\IsbnApplications\Requests;

/**
 * Class IsbnApplicationCreateRequest
 * @package App\Modules\IsbnApplications\Requests
 */
class IsbnApplicationCreateRequest extends IsbnApplicationRequest
{
    public function rules()
    {
        return [
            'isbn_type' => 'required|in:0,1,2,3,4,5,6', // 0 = book, 1=cassette/CD 2=Ebook, 3=Computersoftware, 4=map, 5, microfilm, 6=other
            'title' => 'required|max:191',

            'publisher_id' => 'required|exists:publishers,id',

            'edition' => "required|in:First,Second,Third,Fourth,Fifth,Sixth,
                            Seventh,Eighth,Ninth,Tenth,Eleventh,Twelfth,Thirteenth,Fourteenth,Fifteenth,Sixteenth,
                            Seventeenth,Eighteenth,Nineteenth,Twentieth,Twenty first,Twenty second,Twenty third,Twenty fourth,
                            Twenty fifth,Twenty sixth,Twenty seventh,Twenty eighth,Twenty ninth,Thirtieth,Thirty first,
                            Thirty second,Thirty third,Thirty fourth,Thirty fifth,Thirty sixth,Thirty seventh,Thirty eighth,Thirty ninth,fortieth",
            'subject' => 'required|max:100',
            'accession_number' => 'nullable|max:100',
            'received_status' => 'nullable|in:0,1', // 0=not-received 1=not received

            'language' => 'required|max:100',
            'type' => 'required|in:hardbound,paperback',
            'corporate_author' => 'nullable|max:100',
            'corporate_author_address' => 'nullable|max:191',

            'affiliation_author_address' => 'nullable|max:191',
            'year' => 'required|numeric|min:1000|max:2100',
            'preliminary_page' => 'nullable|max:100',
            'textual_page' => 'nullable|max:100',

            'number_of_pages' => 'nullable|numeric|min:10',
            'price' => 'required|numeric',
            'call_number' => 'nullable|max:191',
            'book_number' => 'nullable|max:20',
            'keywords' => 'nullable|max:191',

            'illustration_type' => 'required|numeric|in:0,1,2,3', // 0 = Chart, 1 = Map, 2 = Tables, 3 = None
            'illustration_color' => 'required|numeric|in:0,1,2',  // 0 = B/w, 1 = color, 2 none
            'photo_illustration' => 'required|numeric|in:0,1,2',
            'book_cover_url' => 'nullable|max:191',

            'last_isbn_number' => 'nullable|max:191',
            'deposit_slip_url' => 'nullable|max:191',
            'readonly' => 'nullable|in:0,1',
            'authors' =>'nullable|array|min:1',
            "authors.*.name"=>'required',
        ];
    }
}
