<?php


namespace App\Modules\IsbnApplications\Filters;

use App\System\IsbnApplication\Database\Models\Author;
use App\System\IsbnApplication\Database\Models\IssuedIsbn;
use NicoSystem\Filters\BaseFilter;

class IsbnFilter extends BaseFilter
{


    public function publisher ($id) {
        $this->builder->where($this->builder->getModel()->getTable().'.publisher_id',  $id);
    }

    public function keyword($keyword)
    {

        if(!$keyword) {
            return;
        }

        $table = $this->builder->getModel()->getTable();
        $this->builder->where("{$table}.title", 'like',"%{$keyword}%");
        $this->builder->orWhere("{$table}.subject", 'like',"%{$keyword}%");
        $this->builder->orWhere((new IssuedIsbn())->getTable().".full_isbn_number", 'like', "%{$keyword}%");

        $ids = Author::where('name','like', "%{$keyword}%")->pluck('isbn_application_id');
        if(!empty($ids)) {
            $this->builder->orWhereIn($table.".id", $ids);
        }

    }

    public function title($title = '')
    {
        $this->keyword($title);
    }

}
