<?php

namespace App\Modules\IsbnApplications\Filters;

use App\System\IsbnApplication\Database\Models\Author;
use App\System\IsbnApplication\Database\Models\IssuedIsbn;
use NicoSystem\Filters\BaseFilter;

/**
 * Class IsbnApplicationsController
 * @package App\Modules\IsbnApplications\Filters
 */
class IsbnApplicationsFilter extends BaseFilter
{
    /**
    * To do filter here
    */
    /**
     * @param $keyword
     * @return mixed
     */
    public function keyword($keyword = null)
    {

        if($keyword) {
            // find ids from authors

           $this->builder->where('title', 'like', "%{$keyword}%")
            ->orWhere('subject','like', "%{$keyword}%")
           ->orWhere((new IssuedIsbn())->getTable().".full_isbn_number", 'like', "%{$keyword}%");
            $this->builder->orWhere($this->builder->getModel()->getTable().'.id','like', "%{$keyword}%");
            if(!empty($ids)) {
                $this->builder->orWhereIn($this->builder->getModel()->getTable().'.id', $ids);
            }
        }
    }

    public function title($title = '')
    {
        $this->keyword($title);
    }

    public function publisher($id = null) {

        if($id){
            $this->builder->where($this->builder->getModel()->getTable().'.publisher_id', $id);
        }
    }

    public function received($status = null) {
        $status = intval($status);
        if($status === 0) {
            $this->builder->where('received_status','<>', 1)
                ->orWhereNull('received_status');
        } elseif($status === 1) {
            $this->builder->where('received_status','=',1);
        }
    }
}
