<?php

namespace App\Modules\IsbnApplications\Controllers;

use App\Modules\IsbnApplications\Interfaces\IsbnApplicationInterface;
use App\Modules\IsbnApplications\Interfaces\IssuedIsbnInterface;
use App\Modules\IsbnApplications\Requests\IsbnApplicationCreateRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationDeleteRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationUpdateRequest;
use App\System\Foundation\FileUpload\Upload;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use NicoSystem\Exceptions\NicoBadRequestException;
use stdClass;

/**
 * Class IsbnApplicationsController
 * @package App\Modules\IsbnApplications\Controllers
 */
class IssuedIsbnController extends BaseController {

    protected $isbnCreateRule = [
        'isbn_number' => 'required|digits_between:1,4',
        'issued_date' => 'required|date',
    ];

    public function __construct(IssuedIsbnInterface $repository)
    {
        $this->repository = $repository;
    }

    public function index(Request $request){
        $data = $request->all();
        return $this->responseOk($this->repository->getList($data));
    }

    public function update(Request $request, $id){
        $data = $request->all();
        $this->validate($request, $this->isbnCreateRule);
        return $this->responseOk($this->repository->update($id,$data));
    }

    public function destroy(Request $request, $id){
        return $this->responseOk($this->repository->destroy($id));
    }

    public function show (Request $request,$id){
        return $this->responseOk($this->repository->getById($id));
    }

}
