<?php

namespace App\Modules\IsbnApplications\Controllers;

use App\Modules\IsbnApplications\Interfaces\IsbnApplicationInterface;
use App\Modules\IsbnApplications\Requests\IsbnApplicationCreateRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationDeleteRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationUpdateRequest;
use App\System\Foundation\FileUpload\Upload;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;

/**
 * Class IsbnApplicationsController
 * @package App\Modules\IsbnApplications\Controllers
 */
class IsbnApplicationsController extends BaseController {
    use Upload;
    /**
     * IsbnApplicationsController constructor.
     * @param IsbnApplicationInterface $repository
     */
    public function __construct(IsbnApplicationInterface $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param IsbnApplicationRequest $request
     * @return \Illuminate\Http\Response
     */
    public function index(IsbnApplicationRequest $request){
        return $this->responseOk($this->repository->getList($request->all()));
    }

    /**
     * @param IsbnApplicationCreateRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(IsbnApplicationCreateRequest $request){
        $data = $request->all();
        $data['deposit_slip_url']= $this->moveFromTemp($request->get('deposit_slip_url'));
        $data['book_cover_url']= $this->moveFromTemp($request->get('book_cover_url'));
        return $this->responseOk($this->repository->create($data));
    }

    /**
     * @param IsbnApplicationUpdateRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function update(IsbnApplicationUpdateRequest $request,$id){
        $data = $request->all();
        $data['deposit_slip_url']= $this->moveFromTemp($request->get('deposit_slip_url'));
        $data['book_cover_url']= $this->moveFromTemp($request->get('book_cover_url'));
        return $this->responseOk($this->repository->update($id,$data));
    }

    /**
     * @param IsbnApplicationDeleteRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function destroy(IsbnApplicationDeleteRequest $request,$id){
        return $this->responseOk($this->repository->destroy($id));
    }

    /**
     * @param IsbnApplicationRequest $request
     * @param $id
     * @return \Illuminate\Http\Response|mixed
     */
    public function show (IsbnApplicationRequest $request,$id){
        return $this->responseOk($this->repository->getById($id));

    }

    public function commitChangesPermanently (IsbnApplicationRequest $request, $id) {
        return $this->responseOk($this->repository->commitChangesPermanently ($id));
    }

    public function markAsReceived (IsbnApplicationRequest $request, $id) {
	$data = $request->all();    
	return $this->responseOk($this->repository->markAsReceived($id, $data));
    }

    public function deleteIsbnApplication (Request $request, $id) {
        return $this->responseOk($this->repository->deleteIsbnApplication($id));
    }
    

}
