<?php

namespace App\Modules\IsbnApplications\Controllers;

use App\Modules\IsbnApplications\Interfaces\IsbnApplicationInterface;
use App\Modules\IsbnApplications\Interfaces\IssuedIsbnInterface;
use App\Modules\IsbnApplications\Requests\IsbnApplicationCreateRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationDeleteRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationRequest;
use App\Modules\IsbnApplications\Requests\IsbnApplicationUpdateRequest;
use App\Modules\IsbnApplications\Requests\IssuedIsbnCreateRequest;
use App\System\Foundation\FileUpload\Upload;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use NicoSystem\Exceptions\NicoBadRequestException;
use stdClass;

/**
 * Class IsbnApplicationsController
 * @package App\Modules\IsbnApplications\Controllers
 */
class ApplicationIssuedIsbnController extends BaseController {

    public function __construct(IssuedIsbnInterface $repository)
    {
        $this->repository = $repository;
    }

    public function store(IssuedIsbnCreateRequest $request, $applicationId){
        $data = $request->all();
        $data['application_id'] = $applicationId;
        return $this->responseOk($this->repository->create($data));
    }

    public function update(IssuedIsbnCreateRequest $request, $applicationId, $id){
        $data = $request->all();
        $data['application_id'] = $applicationId;
        return $this->responseOk($this->repository->update($id,$data));
    }

    public function destroy(Request $request, $applicationId, $id){
        $data = $request->all();
        $data['application_id'] = $applicationId;
        return $this->responseOk($this->repository->destroy($id, $data));
    }

    public function commit (Request $request, $applicationId, $id) {
        return $this->responseOk($this->repository->commit($applicationId, $id));
    }

    public function generateNextISBN (Request $request, $applicationId) {
        return $this->responseOk($this->repository->generateNextIsbn($applicationId));
    }

}
