<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/18/19
 * Time: 2:56 PM
 */

namespace App\Mails;

use App\System\User\Database\Models\User;
use Illuminate\Mail\Mailable;

class PublisherAdminAssignmentMail extends Mailable
{
    /**
     * @var
     */
    public $publisher;
    /**
     * @var User
     */
    public $user;


    public function __construct($publisher, $user)
    {
        $this->publisher=$publisher;
        $this->user=$user;
    }

    public function build()
    {
        return $this->subject($this->publisher->title . " has been assigned to you.")
            ->view('emails.isbn-publisher-admin-assignment')->with([
                'receiver'=> $this->user->first_name,
                'title' => $this->publisher->title . " has been assigned to you.",
            ])->to($this->user->email);
    }
}
